#version 120

uniform sampler2D Texture0;
uniform sampler2D Texture1;
uniform sampler2D Texture2;

uniform float g_OpacityMaskOneBase;
uniform float g_OpacityMaskTwoBase;
uniform float g_Desaturation;

varying vec4 tex; 
varying vec4 tex1; 
varying vec4 color; 

const vec3 coef = vec3(0.3, 0.59, 0.11);

void main (void) 
{	
	vec4 texcol = texture2D( Texture0, tex.st );
	float a = texcol.a;
			
	// Desaturate colors if needed
	texcol.rgb = mix( texcol.rgb, vec3(dot( coef.rgb, texcol.rgb )), g_Desaturation );
	texcol.a = a;
	
	texcol *= color;

	// Apply opacity mask next
	texcol = texcol * abs( g_OpacityMaskOneBase - texture2D( Texture1, tex1.st ).a );
		
	// Apply second opacity mask, which is general for clipping/rounded corners
	if ( g_OpacityMaskTwoBase != 0.0 )
		texcol = texcol * texture2D( Texture2, tex.st ).a;
	
	gl_FragColor = texcol;
}

